/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_33_h__
#define __REG_33_h__
/* ***********************************************************************
   *                                                                     *
   * regx33.h                                                            *
   * Tilmann Wendel , BID R&D, 22. Oct. 1997                             *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   * get from the hardware data base (edit setting data base)            *
   *                                                                     *
   ***********************************************************************
*/


#include "regxdir.h"   /* contains CMD_MERGE and CMDG_PROTOCOLSET_0 */

#define MERGE_TRCGET_0(cmd)	CMD_MERGE (CMDG_TRACEGET_0, cmd)

/* BestTrigSeqGenPropGet */
#define CMDM_TRCTRIG_GENPROPGET	0x05
#define CMD_TRCTRIG_GENPROPGET	MERGE_TRCGET_0 (CMDM_TRCTRIG_GENPROPGET)
#define IN_TRCTRIG_GENPROPGET	4   /* property to get */
#define OUT_TRCTRIG_GENPROPGET	4   /* the value */

/* BestTrigIOGenPropGet */
#define CMDM_TRIGIO_GENPROPGET	0x10
#define CMD_TRIGIO_GENPROPGET	MERGE_TRCGET_0 (CMDM_TRIGIO_GENPROPGET)
#define IN_TRIGIO_GENPROPGET	4   /* property to get */
#define OUT_TRIGIO_GENPROPGET	4   /* the value */

/* BestTracePropGet */
#define CMDM_TRC_PROPGET	0x20
#define CMD_TRC_PROPGET	        MERGE_TRCGET_0 (CMDM_TRC_PROPGET)
#define IN_TRC_PROPGET	        4   /* property to get */
#define OUT_TRC_PROPGET	        4   /* the value */

#endif
